#pragma once
#include "Config.h"

/////////////////////////////////////////////////////////////////////////////
// Constants for CCFC
struct StructCCFC
{
	int reason;		
	int mode;
	CString number;
	int type;
	CString subaddr;
	int satype;
	int classx;
	int time;

	StructCCFC()
	{
	}
	StructCCFC(int iReason, int iMode, CString iNumber="", int iType=-1, int iClassx=-1, CString iSubaddr="", int iSatype=-1, int iTime=-1)
	{
		reason=iReason;
		mode=iMode;
		number=iNumber;
		if (strncmp(iNumber,"+",1)==0)
			type=145;			
		else
			type=129;
		//type=iType;
		subaddr=iSubaddr;
		satype=iSatype;
		classx=iClassx;
		time=iTime;
	}
};
/////////////////////////////////////////////////////////////////////////////
struct StructCCWA
{
	int n;
	CString desc;
	int mode;
	int classx;

	StructCCWA() {}
	StructCCWA(int iN, CString iDesc)
	{
		n=iN;
		desc=iDesc;
	}
};
/////////////////////////////////////////////////////////////////////////////
#define kMaxPhoneNumberLength	30

#define	kSpcHomeCountryKey			"HomeCountry"
#define	kDefaultHomeCountry			"+33"
#define	kCCFCNumberKey				"CCFCNumber"
															
#define	kSpcNwkColpKey				"NwkColp"
#define	kDefaultNwkColp				1
#define	kSpcTaColpKey				"TaColp"
#define	kDefaultTaColp				1
#define	kSpcNwkClirKey				"NwkClir"
#define	kDefaultNwkClir				1
#define	kSpcTaClirKey				"TaClir"
#define	kDefaultTaClir				1
#define	kSpcNwkClipKey				"NwkClip"
#define	kDefaultNwkClip				1
#define	kSpcTaClipKey				"TaClip"
#define	kDefaultTaClip				1
#define kSpcCellResCodeKey			"RingExtFmt"
#define kSpcDefaultCellResCode		0
#define	kSpcCSSIKey					"CSSI"
#define	kSpcDefaultCSSI				0
#define	kSpcCSSUKey					"CSSU"
#define	kSpcDefaultCSSU				0
#define	kSpcUSSDNotifKey			"USSDNotif"
#define	kSpcCallChangeNotifKey		"CallChangeNotif"
#define	kSpcDefaultNotif			0
#define kSpcIsForwKey				"IsForwCall"
#define kSpcDefaultIsForw			0
#define	kSpcCWANotifKey				"CCWANotif"
#define	kSpcDefaultCWANotif			1
#define	kSpcCWAStateKey				"CCWAState"
#define	kSpcDefaultCWAState			1
#define	kSpcCWAStatus0				"CCWAStatus0"
#define	kSpcCWAStatus1				"CCWAStatus1"
#define	kSpcCWAStatus2				"CCWAStatus2"
#define	kSpcCWAStatus3				"CCWAStatus3"
#define	kSpcCWAStatus4				"CCWAStatus4"
#define	kSpcCWAStatus5				"CCWAStatus5"
#define	kSpcCWAStatus6				"CCWAStatus6"
#define	kSpcCWAStatus7				"CCWAStatus7"
#define	kSpcDefaultCWAStatus		1
#define	kSpcFacLockFDKey			"FacLockFD"
#define	kSpcDefaultFacLockFD		0

#define	kSpcFacLockPwdNumber		7
#define	kSpcFacLockPwdLength		4
#define	kSpcFacLockPwdAOKey			"FacLockPwdAO"	// index 0
#define	kSpcFacLockPwdOIKey			"FacLockPwdOI"	// index 1
#define	kSpcFacLockPwdOXKey			"FacLockPwdOX"	// index 2
#define	kSpcFacLockPwdAIKey			"FacLockPwdAI"	// index 3
#define	kSpcFacLockPwdIRKey			"FacLockPwdIR"	// index 4
#define	kSpcFacLockPwdABKey			"FacLockPwdAB"	// index 5
#define	kSpcFacLockPwdAGKey			"FacLockPwdAG"	// index 6

#define	kSpcDefaultFacLockPwd		"0000"

#define	kSpcCallFwdClassNReasonNSection		"CLS%dRSN%d"
#define	kSpcCallFwdClassNFacilityNSection	"CLS%dFAC%d"

#define	kSpcStatusKey				"Stat"
#define	kSpcNumberKey				"Num"
#define	kSpcTimeKey					"Tim"
#define	kSpcSubAddrKey				"SubAddr"
#define	kSpcCSTATypeKey				"CSTAType"
#define	kSpcDefaultCSTAType			129

#define	kSpcDefaultStatus			0
#define	kSpcDefaultNumber			""
#define	kSpcDefaultTime				20
#define	kSpcDefaultSubAddr			""

#define	kSpcBearerSpeedKey			"BSpeed"
#define	kSpcBearerNameKey			"BName"
#define	kSpcBearerCEKey				"BCE"

#define	kSpcDefaultBearerSpeed		0
#define	kSpcDefaultBearerName		0
#define	kSpcDefaultBearerCE			0

#define	kSpcToneDurationKey			"ToneDuration"


#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif

class DLLMANAGER_API CConfigSPC : public CConfig
{
public:	
	CString mHomeCountry;
	// +COLP
	int mTaCOLP;
	int	mNwkCOLP;
	// +CLIR
	int	mTaCLIR;
	int	mNwkCLIR;
	// +CLIP
	int	mTaCLIP;
	int	mNwkCLIP;
	// +CRC
	int	mExtendedFormat;
	// +CSSN
	int	mCSSIenable;
	int	mCSSUenable;
	// +CUSD
	int mUSSDNotif;
	CString mUSSDString;
	int	mDCS;
	// +CCFC
	int mDefaultCCFCMode;
	CString mDefaultCCFCNumber;
	int mDefaultCCFCTime;
	CString mDefaultCCFCSubaddr;
	int mDefaultCCFCClassx;
	int mDefaultCCFCType;
	int mDefaultCCFCSatype;
	CList<StructCCFC*,StructCCFC*> mCCFCList;
	CList<StructIntParam*,StructIntParam*> mCCFCReasonList;
	CList<StructIntParam*,StructIntParam*> mCCFCModeList;

	//int	mIsForwardedCall;
	// +CCWA
	int mDefaultCCWAMode;
	int mDefaultCCWAClassx;
	CList<StructCCWA*,StructCCWA*> mCCWAList;
	int	mCWANotif;
	int	mCWAState;	
//	int	mCWAStatus[kCallClassMaxSupportedValue + 1];
			
	

//	CallFwdReasonStat	mCallFwd[kCallClassMaxSupportedValue + 1];

	// +CCCN
	int	mCallChangeNotif;

	// +CBST	
	int	mBearerSpeed;
	int	mBearerName;
	int	mBearerCE;
	// +VTD
	int	mToneDuration;
	// +CSTA
	int mCSTAType;
	Bool mCSTASetted;
protected:
	DECLARE_SERIAL(CConfigSPC);
public:
	CConfigSPC() {};
	CConfigSPC(CDllManager* iDllManager);
	virtual ~CConfigSPC(void);
	// CConfig Interface Functions	
	virtual Bool Load();
	virtual Bool Save();
	// GET
	virtual CString GetHomeCountry();
	// GET +COLP
	virtual int GetTaCOLP();
	virtual int GetNwkCOLP();
	// GET +CLIP
	virtual int GetTaCLIP();
	virtual int GetNwkCLIP();
	// GET CLIR
	virtual int GetTaCLIR();
	virtual int GetNwkCLIR();
	// GET CCFC	
	virtual StructCCFC* GetReason(int iReason, int iClass);
	virtual CList<StructCCFC*,StructCCFC*>* GetReasonList();
	virtual CString GetSupportedReason();
	// GET CCWA
	virtual StructCCWA* GetCCWAN(int iN);
	virtual CString GetSupportedCCWAN();
	virtual	int		GetCCWANotif(){return mCWANotif;};
	// GET CBST
	virtual int GetBearerSpeed();
	virtual int GetBearerName();
	virtual int GetBearerCE();
	// GET CRC
	virtual int GetExtendedFormat();
	// GET CUSD
    virtual int GetUSSDNotif();
	virtual CString GetUSSDString();
	virtual int GetDCS();
	// GET CCCN
	virtual int GetCallChangeNotif();
	// GET CSTA
	virtual int  GetCSTAType() {return mCSTAType;};
	virtual Bool GetCSTASetted() {return mCSTASetted;};

	// SET
	virtual void SetHomeCountry(CString iPrefix);
	// SET CLIR
	virtual void SetTaCLIR(int iValue);
	virtual void SetNwkCLIR(int iValue);
	// SET +CLIP
	virtual void SetTaCLIP(int iValue);
	virtual void SetNwkCLIP(int iValue);
	// SET +COLP
	virtual void SetTaCOLP(int iValue);
	virtual void SetNwkCOLP(int iValue);
	// SET CCFC	
	virtual void SetCCFCReason(int iReason, int iMode, CString iNumber, int iType, CString iSubaddr, int iSatype, int iClassx, int iTime);
	virtual int AddOrReplaceCCFCReason(int iReason, int iMode, CString iNumber, int iType, CString iSubaddr, int iSatype, int iClassx, int iTime);
	virtual void DeleteCCFCReason(int iReason, int iClass);
	// SET CCWA
	virtual void SetCCWAN(int iN, int iMode, int iClassx);
	virtual void SetCCWANotif(int iNotif) {mCWANotif=iNotif;};
	// +CSSN
	virtual bool IsCSSIenable();
	virtual bool IsCSSUenable();
	virtual void SetCSSU(int iValue);
	virtual void SetCSSI(int iValue);
	// SET CBST
	virtual void SetBearerSpeed(int iBearerSpeed);
	virtual void SetBearerName(int iBearerName);
	virtual void SetBearerCE(int BearerCE);
	// SET CRC
	virtual void SetExtendedFormat(int iMode);
	// SET CUSD
    virtual void SetUSSDNotif(int iUSSDNotif);
	virtual void SetUSSDString(CString iUSSDString);
	virtual void SetDCS(int iDCS);
	// SET CCCN
	virtual void SetCallChangeNotif(int iCallChangeNotif);
	// SET CSTA
	virtual void SetCSTAType(int iType);
	virtual void SetCSTASetted(Bool iVal);
};
